<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ServiceReservation extends Model 
{

    protected $table = 'service_reservation';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('reservation_id', 'service_id', 'created_by', 'updated_by');

    public function reservations()
    {
        return $this->hasMany('App\Models\Reservation', 'reservation_id');
    }

    public function services()
    {
        return $this->hasMany('App\Models\Service', 'service_id');
    }

}